using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class DOD_FRAGMENT_RAW_DATADB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DOD_FRAGMENT_RAW_DATADB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public VIRP.EFR.BO.DOD_FRAGMENT_RAW_DATA GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_RAW_DATA_ID)
		{
			VIRP.EFR.BO.DOD_FRAGMENT_RAW_DATA objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_RAW_DATA_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_RAW_DATA_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<VIRP.EFR.BO.DOD_FRAGMENT_RAW_DATA> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<VIRP.EFR.BO.DOD_FRAGMENT_RAW_DATA> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_RAW_DATA_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.DOD_FRAGMENT_RAW_DATA objSave)
		{
			Int32? objReturn = objSave.DOD_FRAGMENT_RAW_DATA_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_RAW_DATA_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CONTENT_TYPE, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.FILE_DATA, objSave.ORIGINAL_NAME, objSave.SOURCE_LAB, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_RAW_DATA_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_RAW_DATA_delete(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_RAW_DATA_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
